/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  kmer_incidence_map.hpp
 *
 *  Specialization of MotifIncidenceMap for bit-encoded k-mer motifs.
 */


#ifndef KMER_INCIDENCE_MAP_H
#define KMER_INCIDENCE_MAP_H


#include <string>
#include <vector>

#include "common.hpp"
#include "kmer_encoder.hpp"
#include "motif_incidence_map.hpp"


class KmerIncidenceMap : public MotifIncidenceMap {
public:
	KmerIncidenceMap( KmerEncoder& kmer_encoder ) : k( kmer_encoder.kmerSize ), encoder( kmer_encoder ) {}
	virtual ~KmerIncidenceMap() {}
	
	virtual void getMotifName( MotifNumber m, string& motifName ) const;
	
	const unsigned int k;
	KmerEncoder& encoder;
};


#endif // KMER_INCIDENCE_MAP_H
