/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  length_corrected_mann_whitney_u.cpp
 *
 *  ExpressionStatisticCalculator that performs a variant on the Mann-Whitney
 *  test in which null distribution takes into account nonuniform distribution
 *  of ranks being drawn at random.
 *  Based on the concept by Xiaohui Xie 2004
 */


#ifndef LENGTH_CORRECTED_MANN_WHITNEY_U_H
#define LENGTH_CORRECTED_MANN_WHITNEY_U_H


#include <iostream>
#include <fstream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>
#include <map>
#include <cmath>
#include <cstdlib>


#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "univariate_expression_statistic_calculator.hpp"
#include "mark_set.hpp"
#include "mann_whitney_u.hpp"


using namespace std;


class LengthCorrectedMannWhitneyUCalculator : public MannWhitneyUCalculator {
public:
    LengthCorrectedMannWhitneyUCalculator( const PromoterVector& set, unsigned int numsamples = 1000, unsigned int dimension = 0 );
    LengthCorrectedMannWhitneyUCalculator( const LengthCorrectedMannWhitneyUCalculator& calc, bool copyRanks = false );
    virtual ~LengthCorrectedMannWhitneyUCalculator() { }
	
	// accessors
	const dvector&	getSequenceWeights()	const { return sequenceWeights; }
	unsigned int	getNumSamples()			const { return numSamples; }
	
protected:
	void			computeSequenceWeights( const PromoterVector& pv );
	double			computeSequenceWeight( const Promoter& pv ) const;
	
	virtual void	computeNullDistributions();
	
protected:
	dvector			sequenceWeights;
	unsigned int	numSamples;
};


#endif // LENGTH_CORRECTED_MANN_WHITNEY_U_H
