/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  mark_set.cpp
 *
 *  Representation of motif incidence for use with expression statistics.
 */


#include <vector>
#include <numeric>

#include "common.hpp"
#include "mark_set.hpp"


unsigned int
MarkSet::countMarked( bool mark ) const
{
	unsigned count = accumulate( begin(), end(), 0 );
	return ( mark ? count : size() - count );
}
    
double
MarkSet::frequency() const
{
	return static_cast< double >( countMarked( true ) ) / static_cast< double >( size() );
}
	
void
MarkSet::unmark()
{
	fill( begin(), end(), false );
}

