/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  mark_set.hpp
 *
 *  Representation of motif incidence for use with expression statistics.
 */


#ifndef MARK_SET_H
#define MARK_SET_H


#include <vector>


#include "common.hpp"


// class to hold a set of marks for passing to a ExpressionStatisticCalculator
class MarkSet : public vector< bool > {
public:
    MarkSet()	{ }
    MarkSet( size_t n ) : vector< bool >( n, false ) { }
    ~MarkSet()	{ }
	
    unsigned int			countMarked( bool mark )	const;
    
    double					frequency()					const;
	
	void					unmark();
	
	string					motif;
};


#endif // MARK_SET_H
