/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  min_p_value.cpp
 *
 *  Simple StatisticReceiver that stores the most significant nominal
 *  p-value that it receives.
 */


#include <iostream>
#include <string>

#include "common.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"
#include "min_p_value.hpp"


void
MinPValue::receiveStatistic( const string& motif, Statistic* stat )
{
	if( !stat->error )
		if( stat->p < minP )
			minP = stat->p;
}

double
MinPValue::getMinP() const
{
	return minP;
}
