/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  min_p_value.hpp
 *
 *  Simple StatisticReceiver that stores the most significant nominal
 *  p-value that it receives.
 */


#ifndef MIN_P_VALUE_H
#define MIN_P_VALUE_H


#include <iostream>

#include "common.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"


class MinPValue : public StatisticReceiver {
public:
	MinPValue() : minP( 1.0 ) {}
	
	virtual void	receiveStatistic( const string& motif, Statistic* stat );
	
	double			getMinP() const;
	
private:
	double		minP;
};


#endif // MIN_P_VALUE_H
