/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_computer.cpp
 *
 *  Base class for classes that compute the incidences of complex motifs
 *  using a MotifIncidenceMap
 */


#include <string>
#include <vector>

#include "common.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_map.hpp"
#include "motif_incidence_computer.hpp"


void
MotifIncidenceComputer::computeIncidence( MotifIncidenceMap::MotifNumber m, const MotifIncidenceMap* incidenceMap, MotifIncidenceSet& incidence )
{
	const MotifIncidenceSet* mIncidence = incidenceMap->getIncidence( m );
	incidence.addInstances( mIncidence ); // append mIncidence to incidence
}

