/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_map.cpp
 *
 *  Base class for storing a map of from motifs to their incidence.
 */


#include <string>
#include <vector>
#include <iostream>


#include "common.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_map.hpp"


void
MotifIncidenceMap::clear()
{
	iMap.clear();
}


void
MotifIncidenceMap::addInstance( MotifNumber n, const MotifInstance& i )
{
	iMap[ n ].addInstance( i );
}


const MotifIncidenceSet*
MotifIncidenceMap::getIncidence( MotifNumber m ) const
{
	iterator i = iMap.find( m );
	if( i == iMap.end() )
		return 0;
	return &( i->second );
}


void
MotifIncidenceMap::makeUniqueIncidence()
{
	for( IncidenceMapType::iterator i = iMap.begin(); i != iMap.end(); ++i ) {
		MotifIncidenceSet* s = &( i->second );
		s->makeUniqueIncidence();
	}
}


unsigned int
MotifIncidenceMap::size() const
{
	return iMap.size();
}


MotifIncidenceMap::const_iterator
MotifIncidenceMap::begin() const
{
	const_iterator i = iMap.begin();
	return i;
}


MotifIncidenceMap::const_iterator
MotifIncidenceMap::end() const
{
	const_iterator i = iMap.end();
	return i; 
}


MotifIncidenceMap::iterator
MotifIncidenceMap::begin()
{
	iterator i = iMap.begin();
	return i;
}


MotifIncidenceMap::iterator
MotifIncidenceMap::end()
{
	iterator i = iMap.end();
	return i;
}


void
MotifIncidenceMap::touchMotif( MotifNumber n )
{
	iMap[ n ];
}


ostream& operator<<( ostream& os, const MotifIncidenceMap& m )
{
	string motifName;
	os << '{' << endl;
	for( MotifIncidenceMap::const_iterator i = m.begin(); i != m.end(); ++i ) {
		m.getMotifName( i->first, motifName );
		os << '\t' << motifName << ":\t" << i->second << endl;
	}
	os << '}';
	
	return os;
}
