/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_marker.hpp
 *
 *  Base class for marking a MarkSet using a MotifIncidenceSet.
 */


#ifndef MOTIF_INCIDENCE_MARKER_H
#define MOTIF_INCIDENCE_MARKER_H


#include <string>
#include <vector>

#include "common.hpp"
#include "motif_incidence_set.hpp"
#include "mark_set.hpp"


class MotifIncidenceMarker {
public:
	MotifIncidenceMarker() {}
	virtual ~MotifIncidenceMarker() {}
	
	void markIncidence( const MotifIncidenceSet& incidence, MarkSet& marks );
};


#endif // MOTIF_INCIDENCE_MARKER_H
