/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_set.hpp
 *
 *  Class for representing the incidence of a motif.
 */


#ifndef MOTIF_INCIDENCE_SET_H
#define MOTIF_INCIDENCE_SET_H


#include <string>
#include <vector>
#include <iostream>

#include "common.hpp"
#include "motif_instance.hpp"

class MotifIncidenceSet {
public:
	typedef		vector< MotifInstance >			IncidenceVector;
	typedef		IncidenceVector::iterator		iterator;
	typedef		IncidenceVector::const_iterator const_iterator;

public:
	MotifIncidenceSet() {}
	
	void clear();
	
	unsigned int	size() const;
	
	void			addInstance( const MotifInstance& m );
	
	void			addInstances( const MotifIncidenceSet& s );
	void			addInstances( const MotifIncidenceSet* s );
	
	void			makeUniqueIncidence();
	
	iterator		begin();
	iterator		end();
	
	const_iterator  begin()		const;
	const_iterator  end()		const;
	
private:
	IncidenceVector		incidence;
};


ostream& operator<<( ostream& os, const MotifIncidenceSet& s );


#endif // MOTIF_INCIDENCE_SET_H
