/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_instance.cpp
 *
 *  Class for representing an instance of a motif in a sequence
 */


#include <vector>
#include <iostream>

#include "common.hpp"
#include "motif_instance.hpp"


MotifInstance::SequenceNumber
MotifInstance::getSeqNum() const
{
	return seqNum;
}


MotifInstance::SequencePosition
MotifInstance::getSeqPos() const
{
	return seqPos;
}


void
MotifInstance::operator=( const MotifInstance& rhs )
{
	seqNum = rhs.getSeqNum();
	seqPos = rhs.getSeqPos();
}


bool
MotifInstance::operator<( const MotifInstance& rhs ) const
{
	if( getSeqNum() < rhs.getSeqNum() )
		return true;
	if( getSeqNum() == rhs.getSeqNum() )
		return getSeqPos() < rhs.getSeqPos();
	return false;
}


bool
MotifInstance::operator==( const MotifInstance& rhs ) const
{
	return getSeqNum() == rhs.getSeqNum() && getSeqPos() == rhs.getSeqPos();
}



ostream& operator<<( ostream& os, const MotifInstance& i )
{
	os << '(' << i.getSeqNum() << ", " << i.getSeqPos() << ')';
	
	return os;
}
