/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_scanner.cpp
 *
 *  Class for scanning motifs with a given statistic calculator.
 */


#include <string>

#include "common.hpp"
#include "mark_set.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_computer.hpp"
#include "motif_incidence_marker.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"
#include "motif_scanner.hpp"


#include "neighborhood_kmer_incidence_computer.hpp"

void
MotifScanner::scan( ExpressionStatisticCalculator* calc, Statistic* statistic, StatisticReceiver* receiver )
{
	string tmp;
	for( MotifIncidenceMap::iterator i = incidenceMap->begin(); i != incidenceMap->end(); ++i ) {
		incidenceMap->getMotifName( i->first, tmp );
		markMotif( i->first, marks );
		scanMotif( marks, calc, statistic, receiver );
	}
}


void
MotifScanner::markMotif( MotifIncidenceMap::MotifNumber motifNum, MarkSet& marksRef ) {
	incidence.clear();	
	incidenceComputer->computeIncidence( motifNum, incidenceMap, incidence );
	incidenceMap->getMotifName( motifNum, marksRef.motif );
	marker.markIncidence( incidence, marksRef );
}


void
MotifScanner::scanMotif( const MarkSet& marksRef, ExpressionStatisticCalculator* calc, Statistic* statistic, StatisticReceiver* receiver )
{
	calc->compute( marksRef, *statistic );
	receiver->receiveStatistic( marksRef.motif, statistic );
}

