/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_scanner.hpp
 *
 *  Class for scanning motifs with a given statistic calculator.
 */


#ifndef MOTIF_SCANNER_H
#define MOTIF_SCANNER_H


#include <string>

#include "common.hpp"
#include "mark_set.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_computer.hpp"
#include "motif_incidence_marker.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"


class MotifScanner {
public:
	
	MotifScanner( const MotifIncidenceMap* incidence_map, MotifIncidenceComputer* incidence_computer, unsigned int numSeqs )
		: incidenceMap( incidence_map ), incidenceComputer( incidence_computer ), marks( numSeqs ) {}
	
	virtual ~MotifScanner() {}
	
	virtual void	scan( ExpressionStatisticCalculator* calc, Statistic* statistic, StatisticReceiver* receiver );
	
protected:
	
	virtual void	markMotif( MotifIncidenceMap::MotifNumber motifNum, MarkSet& marks );
	
	virtual void	scanMotif( const MarkSet& marksRef, ExpressionStatisticCalculator* calc, Statistic* statistic, StatisticReceiver* receiver );
	
protected:
	
	const MotifIncidenceMap*	incidenceMap;
	MotifIncidenceComputer*		incidenceComputer;
	
	MotifIncidenceMarker		marker;
	
	MotifIncidenceSet			incidence;
	MarkSet						marks;

};


#endif // MOTIF_SCANNER_H
