/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  pwm_motif_incidence_collector.hpp
 *
 *  Class for collecting the incidence of a set of "position weight matrix"
 *  motifs in a set of sequences into a MotifIncidenceMap.
 */


#ifndef NAMED_MOTIF_INCIDENCE_COLLECTOR_H
#define NAMED_MOTIF_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "motif_incidence_map.hpp"
#include "named_motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"


class NamedMotifIncidenceCollector : public MotifIncidenceCollector {
protected:
	
	virtual void collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m ) = 0;
	
	void setMotifNames( const svector& motifNames, NamedMotifIncidenceMap* m );
	
};


#endif // NAMED_MOTIF_INCIDENCE_COLLECTOR_H
