/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  neighborhood_iupac_motif_incidence_collector.hpp
 *
 *  Class for collecting the incidence of a set of IUPAC-degenerate motifs
 *  in a set of sequences into a MotifIncidenceMap, allowing mismatches.
 */


#ifndef NEIGHBORHOOD_IUPAC_MOTIF_INCIDENCE_COLLECTOR_H
#define NEIGHBORHOOD_IUPAC_MOTIF_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "iupac_motif.hpp"
#include "motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "iupac_motif_incidence_collector.hpp"


class NeighborhoodIUPACMotifIncidenceCollector : public IUPACMotifIncidenceCollector {
public:
	
	NeighborhoodIUPACMotifIncidenceCollector( IUPACMotifVector& motif_v, unsigned int r );
	virtual ~NeighborhoodIUPACMotifIncidenceCollector();
	
protected:
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs, IUPACMotifVector& motifs );
	
	virtual void collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m );
	
	unsigned int					hammingDistance( const string& motif, Sequence::DataType::const_iterator textIter ) const;
	Sequence::DataType::size_type   findInSequence( const string& motif, const Sequence& seq, Sequence::DataType::size_type pos ) const;
	
protected:
	unsigned int		radius;
};


#endif // NEIGHBORHOOD_IUPAC_MOTIF_INCIDENCE_COLLECTOR_H
