/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  print_incidence.cpp
 *
 *  Implementation of a statistic calculator that just prints the incidence of the given marks.
 */


#include <iostream>
#include <iomanip>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"
#include "print_incidence.hpp"



// IncidenceStatistic method -- print the summary of the statistic
void
IncidenceStatistic::print( ostream& os ) const
{
    #ifndef MOTIFADE_CRAPPY_IOMANIP
        os << showpoint << fixed;
    #endif
    
    if( error ) {
        
        os << "Err";
        
    } else {
        
		if( incidence.size() > 0 ) {
			
			os << incidence[ 0 ];
			for( unsigned int i = 1; i < incidence.size(); ++i )
				os << ',' << incidence[ i ];
			
		}
		
    }
}


// IncidenceStatistic method -- print the header of the fields
void
IncidenceStatistic::printHeader( ostream& os ) const
{
    os << "Incidence";
}


// PrintIncidence method -- compute and store the incidence for a given MarkSet
void
PrintIncidence::compute( const MarkSet& marks, Statistic& statistic ) // fix this to take a IncidenceStatistic&
{
    unsigned int n = marks.size(), count = 0;
    
    IncidenceStatistic* stat = dynamic_cast< IncidenceStatistic* >( &statistic );
    if( stat == 0 ) throw( MotifADEException( "PrintIncidence::compute: not passed a IncidenceStatistic pointer!" ) );
    
	stat->incidence.clear();
	for( unsigned int i = 0; i < marks.size(); ++i ) {
		if( marks[ i ] ) {
			if( useProbes )
				stat->incidence.push_back( promoters[ i ]->getExpression().getID() );
			else // use NMs
				stat->incidence.push_back( promoters[ i ]->getID() );
			++count;
		}
	}
	
	stat->error = false;
	stat->freq = ( double ) count / ( double ) n;
	
    return;
}


// PrintIncidence method -- dummy method: return the frequency of the marks
double
PrintIncidence::computeValue( const MarkSet& marks )
{	
    return marks.frequency();
}

