/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  print_incidence.hpp
 *
 *  Interface to a statistic calculator that just prints the incidence of the given marks.
 */


#ifndef PRINT_INCIDENCE_H
#define PRINT_INCIDENCE_H


#include <iostream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>
#include <cmath>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"


class IncidenceStatistic : public Statistic {
public:
    IncidenceStatistic( double freq_val = 0 ) : Statistic( true ), freq( freq_val ) { }
    IncidenceStatistic( const IncidenceStatistic& s ) : Statistic( s ), freq( s.freq ) { }
    virtual ~IncidenceStatistic() { }
    
    virtual void	print( ostream& os ) const;
    virtual void	printHeader( ostream& os ) const;

public:
	svector			incidence;
	double			freq;
};


class PrintIncidence : public ExpressionStatisticCalculator {
public:
    PrintIncidence( const PromoterVector& p, bool use_probes = false )
		: promoters( p ),
		  useProbes( use_probes ) { }
	
    virtual ~PrintIncidence() { }
    
    virtual void					compute( const MarkSet& marks, Statistic& statistic ); // fix this to take a IncidenceStatistic&
    
    // ack! terrible!
    virtual double					computeValue( const MarkSet& marks );
    
	bool							usingProbes()	const { return useProbes; }
	
protected:
	const PromoterVector&			promoters;
	const bool						useProbes;
};


#endif // PRINT_INCIDENCE_H
