/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  print_nominally_significant_statistic.cpp
 *
 *  Simple StatisticReceiver that prints its statistic if its nominal p-value is significant.
 */


#include "common.hpp"
#include "expression_statistics.hpp"
#include "print_statistic.hpp"
#include "print_nominally_significant_statistic.hpp"


void
PrintNominallySignificantStatistic::receiveStatistic( const string& motif, Statistic* stat )
{
	if( !stat->error && stat->p < alpha )
		PrintStatistic::receiveStatistic( motif, stat );
}
