/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  print_significant_statistic.hpp
 *
 *  Simple StatisticReceiver that prints its statistic if it is significant.
 */


#ifndef PRINT_SIGNIFICANT_STATISTIC_H
#define PRINT_SIGNIFICANT_STATISTIC_H


#include "common.hpp"
#include "expression_statistics.hpp"
#include "print_statistic.hpp"


class PrintSignificantStatistic : public PrintStatistic {
public:
	PrintSignificantStatistic( ostream& os, double a ) : PrintStatistic( os ), alpha( a ) {}
	
	virtual void receiveStatistic( const string& motif, Statistic* stat );
	
	const double alpha;
};


#endif // PRINT_SIGNIFICANT_STATISTIC_H
