/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  print_statistic.cpp
 *
 *  Simple StatisticReceiver that prints its statistic.
 */


#include <iostream>
#include <string>

#include "common.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"
#include "print_statistic.hpp"


void
PrintStatistic::receiveStatistic( const string& motif, Statistic* stat )
{
	os << motif << '\t';
	stat->print( os );
	os << endl;
}

