/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  print_statistic.hpp
 *
 *  Simple StatisticReceiver that prints its statistic.
 */


#ifndef PRINT_STATISTIC_H
#define PRINT_STATISTIC_H


#include <iostream>

#include "common.hpp"
#include "expression_statistics.hpp"
#include "statistic_receiver.hpp"


class PrintStatistic : public StatisticReceiver {
public:
	PrintStatistic( ostream& printOstream ) : os( printOstream ) {}
	
	virtual void receiveStatistic( const string& motif, Statistic* stat );
	
	ostream& os;
};


#endif // PRINT_STATISTIC_H
