/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  promoter.hpp
 *
 *  Simple class to hold a promoter (i.e. sequence with ortholog sequences).
 */


#ifndef PROMOTER_H
#define PROMOTER_H


#include <algorithm>


#include "common.hpp"
#include "sequence.hpp"
#include "expression_vector.hpp"


using namespace std;


class Promoter : public Sequence {
public:
	~Promoter() { deleteVectorElements( orthologs ); }
	
	unsigned int			numOrthologs()								const { return orthologs.size(); }
	const SequenceVector&   getOrthologs()								const { return orthologs; }
	Sequence*				getOrtholog( unsigned int i )				const { return orthologs[ i ]; }
	void					addOrtholog( Sequence* seq )				{ orthologs.push_back( seq ); }
	
	const ExpressionVector&	getExpression()								const { return expression; }
	double					getExpression( unsigned int i )				const { return expression[ i ]; }
	void					setExpression( const ExpressionVector& v )  { expression = v; }
	
protected:
    SequenceVector			orthologs;
	ExpressionVector		expression;
};


ostream& operator<<( ostream& os, const Promoter& p );


typedef vector< Promoter* >			PromoterVector;


#endif // PROMOTER_H
