/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  named_motif_incidence_collector.cpp
 *
 *  Class for collecting the incidence of a set of explicitly named motifs
 *  in a set of sequences into a MotifIncidenceMap.
 */


#ifndef PWM_MOTIF_INCIDENCE_COLLECTOR_H
#define PWM_MOTIF_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "pwm_motif.hpp"
#include "motif_incidence_map.hpp"
#include "pwm_motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "named_motif_incidence_collector.hpp"
#include "pwm_motif_incidence_collector.hpp"


class PWMMotifIncidenceCollector : public NamedMotifIncidenceCollector {
public:
	
	PWMMotifIncidenceCollector( PWMMotifVector& motif_v ) : motifVector( motif_v ) {}
	virtual ~PWMMotifIncidenceCollector() {}
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs );
	
protected:
	
	virtual void collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m );
	virtual void collectIncidence( MotifIncidenceMap::MotifNumber motifNum, const PWMMotifVector& motifs, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m );
	
	virtual void setMotifNames( PWMMotifVector& motifs, PWMMotifIncidenceMap* m );
	
protected:
	
	PWMMotifVector& motifVector;
};


#endif // PWM_MOTIF_INCIDENCE_COLLECTOR_H
