/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  pwm_motif_vector_reader.cpp
 *
 *  Class that reads an PWMMotifVector from a stream.
 */


#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"
#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "pwm_motif.hpp"
#include "pwm_motif_vector_reader.hpp"


void
PWMMotifVectorReader::load( PWMMotifVector& motifs, Stats& stats )
{
	stats.clear();
	
	if( !is ) throw( MotifADEException( "PWMMotifVectorReader::load: couldn't read from stream!" ) );
	
	PWMMotif* tmp;
	while( !is.eof() ) {
		char ch = is.peek();
		if( !isprint( ch ) ) {
			is.get();
			continue;
		}
		
		tmp = new PWMMotif;
		
//		try {
			is >> *tmp;
			++stats.num_motifs_loaded;
			motifs.push_back( tmp );
//		} catch( std::exception& e ) {
//			cout << "Exception caught in PWMMotifVectorReader::load: " << e.what() << endl;
//		}
	}
	
	stats.num_valid_motifs = motifs.size();
}
