/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  student_t.hpp
 *
 *  Class that performs a Student's T-test
 */


#ifndef STUDENT_T_H
#define STUDENT_T_H


#include <iostream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>
#include <cmath>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "univariate_expression_statistic_calculator.hpp"
#include "mark_set.hpp"


// Student T statistic class
class StudentT : public Statistic {
public:
    StudentT( double mean1, double var1, double num1, double mean2, double var2, double num2 );
    
    StudentT( double freq_val = 0 ) : Statistic( true ), freq( freq_val ), df( 0 ), sd( 0 ), t( 0 ), m1( 0 ), v1( 0 ), n1( 0 ), m2( 0 ), v2( 0 ), n2( 0 ) { }
    StudentT( const StudentT& s ) : Statistic( s ), freq( s.freq ), df( s.df ), sd( s.sd ), t( s.t ), m1( s.m1 ), v1( s.v1 ), n1( s.n1 ), m2( s.m2 ), v2( s.v2 ), n2( s.n2 ) { }
    virtual ~StudentT() { }
    
    virtual void				print( ostream& os ) const;
    virtual void				printHeader( ostream& os ) const;
	
private:
	void						computeParams();
    
public: // (should be) constant public data members
    double						freq, df, sd, t;
    double						m1, v1, n1;
	double						m2, v2, n2;
};


// class to implement a fast caching calculator for a the Student T statistic
class StudentTCalculator : public UnivariateExpressionStatisticCalculator {
public:
    StudentTCalculator( const PromoterVector& promoters, bool use_residuals = false, double alpha_val = 1.0, unsigned int dimension = 0 )
		: UnivariateExpressionStatisticCalculator( promoters, dimension ),
		  useResiduals( use_residuals ),
		  alpha( alpha_val ) { }
	
    StudentTCalculator( const StudentTCalculator& calc)
		: UnivariateExpressionStatisticCalculator( calc ),
		  useResiduals( calc.usingResiduals() ),
		  alpha( calc.getAlpha() ) { }
	
    virtual ~StudentTCalculator() { }
    
    virtual void					compute( const MarkSet& marks, Statistic& statistic ); // fix this to take a StudentT&
    
    // ack! terrible!
    virtual double					computeValue( const MarkSet& marks );
    
    // accessors
	bool							usingResiduals()	const { return useResiduals; }
	double							getAlpha()			const { return alpha; }
	
protected:
	const bool						useResiduals;
	const double					alpha;
	
};


#endif // STUDENT_T_H
