/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  statistics.cpp
 *
 *  Implementation of expresssion statistics data abstraction.
 */


#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "univariate_expression_statistic_calculator.hpp"


using namespace std;


// UnivariateExpressionStatisticCalculator constructor -- reads a given dimension of expression data from a given PromoterVector into local storage
UnivariateExpressionStatisticCalculator::UnivariateExpressionStatisticCalculator( const PromoterVector& promoters, unsigned int dimension )
    : expression( promoters.size() )
{
    loadExpressionDimension( promoters, dimension );
}


// UnivariateExpressionStatisticCalculator method -- reads a given dimension of expression data from a given SequenceSet into local storage
void
UnivariateExpressionStatisticCalculator::loadExpressionDimension( const PromoterVector& promoters, unsigned int dimension )
{
    for( unsigned int i = 0; i < promoters.size(); ++i )
		expression[ i ] = promoters[ i ]->getExpression( dimension );
}


// UnivariateExpressionStatisticCalculator method -- shuffles the expression data
void
UnivariateExpressionStatisticCalculator::shuffleExpression()
{
    random_shuffle( expression.begin(), expression.end() );
}

