/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  statistics.hpp
 *
 *  Expresssion statistics data abstraction.
 */


#ifndef UNIVARIATE_EXPRESSION_STATISTIC_CALCULATOR_H
#define UNIVARIATE_EXPRESSION_STATISTIC_CALCULATOR_H


#include <iostream>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>


#include "common.hpp"
#include "promoter.hpp"
#include "mark_set.hpp"
#include "expression_statistics.hpp"


using namespace std;


// abstract expression statistic calculator class
class UnivariateExpressionStatisticCalculator : public ExpressionStatisticCalculator {
public:
    UnivariateExpressionStatisticCalculator( const PromoterVector& promoters, unsigned int dimension = 0 );
    UnivariateExpressionStatisticCalculator( const UnivariateExpressionStatisticCalculator& calc ) : expression( calc.getExpression() ) { }
    virtual ~UnivariateExpressionStatisticCalculator() { }
    
    void				loadExpressionDimension( const PromoterVector& promoters, unsigned int dimension );
    
    virtual void		shuffleExpression();
    
    virtual void		compute( const MarkSet& marks, Statistic& statistic ) = 0;
    virtual double		computeValue( const MarkSet& marks ) = 0;
    
    // accessors
    const dvector&		getExpression() const { return expression; }

protected: // change back to protected
    dvector				expression;
};


#endif // UNIVARIATE_EXPRESSION_STATISTIC_CALCULATOR_H
