/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  bidirectional_kmer_incidence_map.hpp
 *
 *  Specialization of KmerIncidenceMap that treats motifs on the (+) and
 *  (-) strands as instances of the same motifs.
 */


#ifndef BIDIRECTIONAL_KMER_INCIDENCE_MAP_H
#define BIDIRECTIONAL_KMER_INCIDENCE_MAP_H


#include <string>
#include <vector>

#include "common.hpp"
#include "kmer_encoder.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_map.hpp"
#include "kmer_incidence_map.hpp"


class BidirectionalKmerIncidenceMap : public KmerIncidenceMap {
public:
	BidirectionalKmerIncidenceMap( KmerEncoder& kmer_encoder ) : KmerIncidenceMap( kmer_encoder ) {}
	virtual ~BidirectionalKmerIncidenceMap() {}
	
	virtual void addInstance( MotifNumber m, const MotifInstance& i );
	
	virtual const MotifIncidenceSet* getIncidence( MotifNumber m ) const;
	
	virtual void getMotifName( MotifNumber m, string& motifName ) const;
};


#endif // BIDIRECTIONAL_KMER_INCIDENCE_MAP_H
