/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  collect_incidence_matrix.hpp
 *
 *  Statistic calculator that collects the MarkSets given into a matrix.
 */


#ifndef COLLECT_INCIDENCE_MATRIX_H
#define COLLECT_INCIDENCE_MATRIX_H


#include <iostream>
#include <iomanip>
#include <vector>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"


class CollectIncidenceMatrix : public ExpressionStatisticCalculator {
public:
    CollectIncidenceMatrix( const PromoterVector& p, ostream& outStream, bool use_probes = true );
	
    virtual ~CollectIncidenceMatrix() { }
    
    virtual void					compute( const MarkSet& marks, Statistic& statistic ); // 2nd parameter not used
    
    // not used
    virtual double					computeValue( const MarkSet& marks );
    
	bool							usingProbes()	const { return useProbes; }
	
	void							printIncidenceMatrix() const;
	
protected:
	vector< MarkSet >				incidence;
	const bool						useProbes;
	const PromoterVector&			pv;
	ostream&						os;
};


#endif // COLLECT_INCIDENCE_MATRIX_H
