/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  dfa_iupac_motif_incidence_collector.hpp
 *
 *  Class for collecting the incidence of a set of IUPAC-degenerate motifs
 *  in a set of sequences into a MotifIncidenceMap, using Patrick Varilly's
 *  DFA IUPAC motif matching code.
 */


#ifndef DFA_IUPAC_MOTIF_INCIDENCE_COLLECTOR_H
#define DFA_IUPAC_MOTIF_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "iupac_motif.hpp"
#include "motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "iupac_motif_incidence_collector.hpp"


class DFAIUPACMotifIncidenceCollector : public IUPACMotifIncidenceCollector {
public:
	
	DFAIUPACMotifIncidenceCollector( IUPACMotifVector& motif_v ) : IUPACMotifIncidenceCollector( motif_v ) {}
	virtual ~DFAIUPACMotifIncidenceCollector() {}
	
protected:
	
	virtual void collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m );
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs, IUPACMotifVector& motifs );
};


#endif // IUPAC_MOTIF_INCIDENCE_COLLECTOR_H
