/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  expression_annotator.hpp
 *
 *  Class to associate expression vectors with promoters using an SequenceExpressionMap
 */


#include <set>

#include "common.hpp"

#include "promoter.hpp"
#include "promoter_set.hpp"

#include "sequence_expression_map.hpp"
#include "operation_stats.hpp"
#include "expression_annotator.hpp"


void
ExpressionAnnotator::annotate( SequenceExpressionMap& seMap, ExpressionSet& expression, ExpressionAnnotator::Stats& stats )
{
	stats.clear();
	
	stats.num_mappings_in_map = seMap.size();
	stats.promoter_set_size = promoters.size();
	stats.expression_set_size = expression.size();
	stats.removePromotersWithoutExpression = removeNonAnnotated;
	
	for( PromoterSet::iterator i = promoters.begin(); i != promoters.end(); ++i ) {
		Promoter* p = *i;
		SequenceExpressionMap::iterator e = seMap.find( p->getID() );
		if( e != seMap.end() ) {
			++stats.num_promoters_with_expression_in_map;
			const ExpressionVector::IDType& eID = e->second;
			ExpressionVector* v = expression.get( eID );
			if( v != 0 ) {
				++stats.num_promoters_with_expression;
				p->setExpression( *v );
			} else {
				stats.nonAnnotatedIDs.insert( p->getID() );
			}
		} else {
			stats.nonAnnotatedIDs.insert( p->getID() );
		}
	}
	
	if( removeNonAnnotated ) {
		for( IDSet::iterator i = stats.nonAnnotatedIDs.begin(); i != stats.nonAnnotatedIDs.end(); ++i )
			promoters.remove( *i );
	}
	
	stats.num_promoters_retained = promoters.size();
}
