/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  expression_vector.cpp
 *
 *  Simple class for storing a vector of expression data.
 */


#include <vector>
#include <iostream>
#include <algorithm>

#include "common.hpp"
#include "buffered_reader.hpp"
#include "tokenizer.hpp"
#include "id_object.hpp"
#include "expression_vector.hpp"


// method to read an ExpressionVector from a BufferedReader (need to make BufferedReader an istream!)
BufferedReader& operator>>( BufferedReader& is, ExpressionVector& ev )
{
	if( !is ) throw( MotifADEException( "operator>>( BufferedReader&, ExpressionVector& ): couldn't read from stream!" ) );
	
	string buf;
	svector tokens;
	
	ev.clear();
	is.getline( buf, '\n' );
	
	if( buf.empty() ) throw( MotifADEException( "operator>>( BufferedReader&, ExpressionVector& ): line is empty!" ) );
	
	tokenize( back_inserter( tokens ), buf, '\t' );
	
	ev.setID( tokens[ 0 ] );
	transform( tokens.begin() + 1, tokens.end(), back_inserter( ev ), string_atof );
	
	return is;
}


ostream& operator<<( ostream& os, const ExpressionVector& ev ) {
	os << ev.getID() << ':';
	for( ExpressionVector::const_iterator i = ev.begin(); i != ev.end(); ++i )
		os << '\t' << *i;
	return os;
}


