/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gap_kmer_encoder.hpp
 *
 *  Interface to a class for converting k-mers with gaps into ints
 */


#ifndef GAP_KMER_ENCODER_H
#define GAP_KMER_ENCODER_H


#include <iostream>
#include <vector>
#include <string>


#include "common.hpp"
#include "sequence.hpp"
#include "kmer_encoder.hpp"


class GapKmerEncoder : public KmerEncoder {
public:
	GapKmerEncoder( const string& gap_format );
	virtual ~GapKmerEncoder();
	
	virtual void						kmerValueToSequence( KmerValue value, string& s ) const;
	
	virtual KmerValue					computeKmerValue( NtSeqType::const_iterator pos ) const;
	virtual KmerValue					nextKmerValue( KmerValue currentValue, NtSeqType::const_iterator pos ) const;
	
	virtual NtSeqType::const_iterator   getFirstPos( const NtSeqType& seq ) const;
	virtual NtSeqType::const_iterator   getLastPos( const NtSeqType& seq ) const;
	
public:
	unsigned int						fullLength;
	
protected:
	unsigned int						countNucleotides( const string& gap_format );
	unsigned int						parseGapFormat( const string& gap_format );
	
protected:
	uvector								ntPositions;
};


#endif // GAP_KMER_ENCODER_H
