/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_collection.hpp
 *
 *  Simple specialization of map to a hold instances of GeneIDSet.
 */


#ifndef GENE_ID_SET_COLLECTION_H
#define GENE_ID_SET_COLLECTION_H

#include <map>

#include "common.hpp"
#include "gene_id_set.hpp"


class GeneIDSetCollection : public map< string, GeneIDSet > {};


ostream& operator<<( ostream& os, const GeneIDSetCollection& geneSets );


#endif // GENE_ID_SET_COLLECTION_H
