/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_collection_reader.hpp
 *
 *  Class that reads a collection of GeneIDSet objects
 *  from a stream, e.g. a file created using the -i option.
 */


#include <iostream>
#include <string>
#include <cctype>
#include <algorithm>
#include <iterator>


#include "common.hpp"
#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "gene_id_set.hpp"
#include "gene_id_set_collection.hpp"
#include "gene_id_set_collection_reader.hpp"

		
void
GeneIDSetCollectionReader::load( GeneIDSetCollection& geneSets, Stats& stats ) {
	stats.clear();
	
	if( !is ) throw( MotifADEException( "GeneIDSetCollectionReader::load: couldn't read from stream!" ) );
	
	string tmp, header, geneSetName, geneSetStr;
	
	is.getline( header, '\n' );
	
	while( !is.eof() ) {
		char ch = is.peek();
		if( !isprint( ch ) ) {
			is.get();
			continue;
		}
		
		is.getline( tmp, '\n' );
		
		++stats.num_sets_loaded;
		stats.num_ids_loaded += count( tmp.begin(), tmp.end(), ',' ) + 1;
		
		split( tmp, geneSetName, geneSetStr,'\t' );
		
		GeneIDSet& geneSet = geneSets[ geneSetName ];
		tokenize( inserter( geneSet, geneSet.end() ), geneSetStr, ',' );
	}
	
	stats.num_sets_retained = geneSets.size();
	
	stats.num_ids_retained = 0;
	for( GeneIDSetCollection::const_iterator i = geneSets.begin(); i != geneSets.end(); ++i )
		stats.num_ids_retained += i->second.size();
}

