/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_collection_reader.hpp
 *
 *  Class that reads a collection of GeneIDSet objects
 *  from a stream, e.g. a file created using the -i option.
 */


#ifndef GENE_ID_SET_COLLECTION_READER_H
#define GENE_ID_SET_COLLECTION_READER_H


#include <set>
#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"


#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "gene_id_set_collection.hpp"


// nearly stateless class to read a GeneIDSet from a stream
class GeneIDSetCollectionReader {
public:
	struct Stats : OperationStats {
		Stats() { clear(); }
		
		virtual void clear() {
			num_sets_loaded = 0;
			num_sets_retained = 0;
			num_ids_loaded = 0;
			num_ids_retained = 0;
		}
		
		virtual ostream& print( ostream& os ) const {
			os << num_sets_loaded << " gene sets loaded." << endl;
			os << num_sets_retained << " gene sets retained." << endl;
			os << num_ids_loaded << " IDs loaded." << endl;
			os << num_ids_retained << " IDs retained." << endl;
			return os;
		}
		
		unsigned int	num_sets_loaded,
						num_sets_retained,
						num_ids_loaded,
						num_ids_retained;
	};
		
	GeneIDSetCollectionReader( BufferedReader& ist )
		: is( ist ) { }
	
	void	load( GeneIDSetCollection& geneSets, Stats& stats );
	
private:
	BufferedReader& is;
};


#endif // GENE_ID_SET_COLLECTION_READER_H
