/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_marker.cpp
 *
 *  Simple class that marks which genes in a PromoterVector appear in a given list.
 */


#include <map>
#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "promoter.hpp"
#include "mark_set.hpp"
#include "gene_id_set.hpp"
#include "gene_id_set_marker.hpp"


// LOOK! SUPER-REDUNDANT COPY-AND-PASTE CODE! BAD! FACTOR THIS!!!
GeneIDSetMarker::GeneIDSetMarker( const SequenceVector& seqs )
	: numPromoters( seqs.size() ), useExpressionIDs( false )
{
	for( unsigned int i = 0; i < seqs.size(); ++i ) {
		const Sequence::IDType& id = seqs[ i ]->getID(); // WARNING! what if Sequence::IDType and Promoter::IDType are not the same??
		idToIndex[ id ] = i;
	}
}


GeneIDSetMarker::GeneIDSetMarker( const PromoterVector& promoters, bool use_expression_ids )
	: numPromoters( promoters.size() ), useExpressionIDs( use_expression_ids )
{
	for( unsigned int i = 0; i < promoters.size(); ++i ) {
		const Promoter& p = *promoters[ i ];
		const Promoter::IDType& id = use_expression_ids ? p.getExpression().getID() : p.getID(); // WARNING! what if Promoter::IDType and ExpressionVector::IDType are not the same??
		idToIndex[ id ] = i;
	}
}


unsigned int
GeneIDSetMarker::markGeneSet( const GeneIDSet& geneSet, MarkSet& marks )
{
	if( marks.size() != numPromoters )
		throw( MotifADEException( "GeneSetMarker::markGeneSet: marks.size() != numPromoters" ) );
	
	markGeneSet( geneSet, indexScratch );
	
	marks.unmark();
	for( unsigned int i = 0; i < indexScratch.size(); ++i )
		marks[ indexScratch[ i ] ] = true;
	
	return indexScratch.size();
}


unsigned int
GeneIDSetMarker::markGeneSet( const GeneIDSet& geneSet, uvector& indices )
{
	indices.clear();
	
	for( GeneIDSet::const_iterator i = geneSet.begin(); i != geneSet.end(); ++i ) {
		IDMapType::const_iterator j = idToIndex.find( *i );
		if( j != idToIndex.end() )
			indices.push_back( j->second );
	}
	
	return indices.size();
}
