/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_marker.hpp
 *
 *  Simple class that marks which genes in a PromoterVector appear in a given list.
 */


#ifndef GENE_ID_SET_MARKER_H
#define GENE_ID_SET_MARKER_H


#include <map>
#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "promoter.hpp"
#include "gene_id_set.hpp"
#include "mark_set.hpp"


class GeneIDSetMarker {
private:
	typedef map< Promoter::IDType, unsigned int >   IDMapType;
	
public:
	GeneIDSetMarker( const SequenceVector& seqs );
	GeneIDSetMarker( const PromoterVector& promoters, bool use_expression_ids = false );
	
	unsigned int markGeneSet( const GeneIDSet& geneSet, MarkSet& marks );
	unsigned int markGeneSet( const GeneIDSet& geneSet, uvector& indices );
	
private:
	IDMapType		idToIndex;
	unsigned int	numPromoters;
	bool			useExpressionIDs;
	
	uvector			indexScratch;
};

#endif // GENE_ID_SET_MARKER_H
