/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_reader.cpp
 *
 *  Interface to a class that reads an GeneIDSet from a stream.
 */


#include <set>
#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"
#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "gene_id_set.hpp"
#include "gene_id_set_reader.hpp"

		
void
GeneIDSetReader::load( GeneIDSet& geneSet, Stats& stats ) {
	stats.clear();
	
	if( !is ) throw( MotifADEException( "GeneIDSetReader::load: couldn't read from stream!" ) );
	
	GeneIDSet::value_type tmp;
	
	while( !is.eof() ) {
		char ch = is.peek();
		if( !isprint( ch ) ) {
			is.get();
			continue;
		}
		
		is.getline( tmp, '\n' );
		
		++stats.num_ids_loaded;
		
		
		bool unique = geneSet.insert( tmp ).second;
		
		if( !unique )
			++stats.num_id_repeats;
	}
	
	stats.num_ids_retained = geneSet.size();	
}

