/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_id_set_reader.hpp
 *
 *  Interface to a class that reads an GeneIDSet from a stream.
 */


#ifndef GENE_ID_SET_READER_H
#define GENE_ID_SET_READER_H


#include <set>
#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"


#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "gene_id_set.hpp"


// nearly stateless class to read a GeneIDSet from a stream
class GeneIDSetReader {
public:
	struct Stats : OperationStats {
		Stats() { clear(); }
		
		virtual void clear() {
			num_ids_loaded = 0;
			num_id_repeats = 0;
			num_ids_retained = 0;
		}
		
		virtual ostream& print( ostream& os ) const {
			os << num_ids_loaded << " gene IDs loaded." << endl;
			os << num_id_repeats << " repeated IDs." << endl;
			os << num_ids_retained << " IDs retained." << endl;
			return os;
		}
		
		unsigned int	num_ids_loaded,
						num_id_repeats,
						num_ids_retained;
	};
		
	GeneIDSetReader( BufferedReader& ist )
		: is( ist ) { }
	
	void	load( GeneIDSet& geneSet, Stats& stats );
	
private:
	BufferedReader& is;
};


#endif // GENE_ID_SET_READER_H
