/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  gene_set_motif_enrichment_base.hpp
 *
 *  Base class for expression statistic calculators that compare the incidence
 *  of motifs in a given gene set to background.
 */


#ifndef GENE_SET_MOTIF_ENRICHMENT_BASE_H
#define GENE_SET_MOTIF_ENRICHMENT_BASE_H


#include <iostream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <numeric>
#include <vector>

#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "mark_set.hpp"


class GeneSetEnrichmentBase : public Statistic {
public:
    GeneSetEnrichmentBase();
    GeneSetEnrichmentBase( unsigned int num_inside, unsigned int inside_size, unsigned int num_outside, unsigned int outside_size );    
    virtual ~GeneSetEnrichmentBase() { }
    
public: // (should be) constant public data members
    unsigned int	numInside, insideSize;
    unsigned int	numOutside, outsideSize;
	unsigned int	numTotal, totalSize;
    double			freqInside, freqOutside, freq;
};


class GeneSetEnrichmentBaseCalculator : public ExpressionStatisticCalculator {
public:
    GeneSetEnrichmentBaseCalculator( const PromoterVector& promoters, const MarkSet& gene_set );
    GeneSetEnrichmentBaseCalculator( const GeneSetEnrichmentBaseCalculator& calc );
    virtual ~GeneSetEnrichmentBaseCalculator() { }
    
	const MarkSet&		getGeneSet()		const { return geneSet; }
	
	unsigned int		getTotalSize()		const { return totalSize; }	
	unsigned int		getGeneSetSize()	const { return geneSetSize; }
	unsigned int		getRestSize()		const { return restSize; }
	
protected:
	void				countIntersection( const MarkSet& marks, unsigned int& numInside, unsigned int& numOutside ) const;
	
protected:
	MarkSet				geneSet;
	unsigned int		totalSize, geneSetSize, restSize;
	
};

#endif // GENE_SET_MOTIF_ENRICHMENT_BASE_H

