/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  id_object_set.hpp
 *
 *  Templated class for storing a "set" of elements that each have an ID.
 */


#ifndef ID_SET_H
#define ID_SET_H


#include <iostream>
#include <fstream>
#include <functional>
#include <string>
#include <vector>
#include <list>
#include <iterator>
#include <map>

#include "common.hpp"


// iterator over the sequences in a IDObjectSet
template< typename IDMapType, typename iterator = typename IDMapType::iterator >
struct IDObjectSetIterator {
	typedef		typename IDMapType::mapped_type T;
	
	IDObjectSetIterator( const iterator& __it ) { rep = __it; }
	IDObjectSetIterator( const IDObjectSetIterator& __it ) { rep = __it.rep; }

	T&
	operator*() const { return ( *rep ).second; }

	T*
	operator->() const { return &( operator*() ); }

	IDObjectSetIterator& 
	operator++() 
	{
		++rep;
		return *this; 
	}

	IDObjectSetIterator 
	operator++(int) 
	{
		IDObjectSetIterator __tmp = *this;
		++rep;
		return __tmp;
	}

	IDObjectSetIterator& 
	operator--()
	{
		--rep;
		return *this;
	}

	IDObjectSetIterator 
	operator--(int) 
	{
		IDObjectSetIterator __tmp = *this;
		--rep;
		return __tmp;
	}
	
	bool
	operator==( const IDObjectSetIterator& __y )
	{
		return rep == __y.rep;
	}
	
	bool
	operator!=( const IDObjectSetIterator& __y )
	{
		return rep != __y.rep;
	}
	
	iterator   rep;
};


template< typename T >
class IDObjectSet {
public:
	typedef T									IDObjectType;
	typedef map< typename T::IDType, T* > IDMap;
	
	typedef IDObjectSetIterator< IDMap >							iterator;
	typedef IDObjectSetIterator< IDMap, typename IDMap::const_iterator >		const_iterator;
//	typedef iterator												const_iterator; // FUCK!
	
public:
	IDObjectSet() {}
	virtual ~IDObjectSet()
	{
		for( typename IDMap::iterator i = imap.begin(); i != imap.end(); ++i ) {
			T* ptr = i->second;
			if( ptr == 0 )
				cout << "ptr == 0!!!" << endl;
			delete ptr;
		}
	}
	
	iterator					begin()		{ return iterator( imap.begin() ); }
	iterator					end()		{ return iterator( imap.end() ); }

	const_iterator				begin()		const { return const_iterator( imap.begin() ); }
	const_iterator				end()		const { return const_iterator( imap.end() ); }
	
	typename IDMap::size_type   size()		const { return imap.size(); }
	
	virtual bool				add( T* obj )
	{
		if( obj == 0 ) throw( MotifADEException( "IDObjectSet::add: obj is null!" ) );
		return imap.insert( typename IDMap::value_type( obj->getID(), obj ) ).second;
	}
	
	virtual T*					get( const typename T::IDType& id ) const
	{
		typename IDMap::const_iterator i = imap.find( id );
		return i != imap.end() ? i->second : 0;
	}
	
	virtual bool				remove( const typename T::IDType& id, bool deleteObj = true )
	{
		typename IDMap::iterator i = imap.find( id );
		if( i == imap.end() )
			return false;
		if( deleteObj )
			delete i->second;
		imap.erase( i );
		return true;
	}
	
	virtual void				asVector( vector< T* >& v )
	{
		v.resize( size() );
		unsigned int j = 0;
		for( iterator i = begin(); i != end(); ++i )
			v[ j++ ] = *i;
	}

private:
	IDMap imap;
};


#endif // ID_SET_H
