/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  iupac_alphabet.hpp
 *
 *  Implementation of an IUPAC character matching facility
 *
 *  Copyright (c) 2003-2005 Dan Arlow. All rights reserved. DO NOT DISTRIBUTE.
 *
 *  CREATED  07/18/05
 *  MODIFIED 07/18/05
 *
 *  Written by Patrick Varilly.
 *
 */

#ifndef IUPAC_ALPHABET_H
#define IUPAC_ALPHABET_H

#include <algorithm>
#include <string>

#include "common.hpp"


using namespace std;

// gPatternMatch[x][y] is true if IUPAC pattern character x matches y
// e.g. gPatternMatch['A']['A'] is true
//      gPatternMatch['N']['A' or 'C' or 'G' or 'T'] is true
// etc.
extern char gPatternMatch[256][256];

// deal with type conversions transparently
// these don't generate extra code, they just specify what assembly
// instructions to use when computing array offsets
template< class T >
inline bool doesIUPACMatchChar( T inIUPAC, T inChar )
{
	return bool( gPatternMatch[ uint8_t( inIUPAC ) ][ uint8_t( inChar ) ] );
}

// reverse complementing of an IUPAC string
extern char gIUPACReverseComplChar[256];

template< class T >
inline T IUPACReverseComplement( T inIUPAC )
{
	return T( gIUPACReverseComplChar[ uint8_t( inIUPAC ) ] );
}

inline void iupac_reverse( string &str )
{
	for( unsigned int i = 0; i < str.size(); i++ )
		str[i] = IUPACReverseComplement( str[i] );
}

#endif /* IUPAC_ALPHABET_H */
