/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  iupac_motif_vector_reader.cpp
 *
 *  Class that reads an IUPACMotifVector from a stream.
 */


#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"
#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "iupac_motif.hpp"
#include "iupac_motif_vector_reader.hpp"


void
IUPACMotifVectorReader::load( IUPACMotifVector& motifs, Stats& stats )
{
	stats.clear();
	string buf, name, patterns, revcPatterns;
	
	if( !is ) throw( MotifADEException( "IUPACMotifVectorReader::load: couldn't read from stream!" ) );
	
	while( !is.eof() ) {
		char ch = is.peek();
		if( !isprint( ch ) ) {
			is.get();
			continue;
		}
		
		++stats.num_motifs_loaded;
		
		is.getline( buf, '\n' );
		if( IUPACMotif::isValidRaw( buf ) ) {
			IUPACMotif* motif = new IUPACMotif( buf );
			if( useBidirectional ) {
				name = motif->getName();
				name += "_+/-";
				motif->getPatterns( patterns );
				motif->getReverseComplementPatterns( revcPatterns );
				patterns += '|';
				patterns += revcPatterns;
				IUPACMotif* tmpMotif = new IUPACMotif( name, patterns );
				delete motif;
				motif = tmpMotif;
			}
			
			motifs.push_back( motif );
			++stats.num_valid_motifs;
		}
	}		
}
