/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  iupac_motif_vector_reader.hpp
 *
 *  Class that reads an IUPACMotifVector from a stream.
 */

#ifndef IUPAC_MOTIF_VECTOR_READER_H
#define IUPAC_MOTIF_VECTOR_READER_H

#include <iostream>
#include <string>
#include <cctype>


#include "common.hpp"
#include "buffered_reader.hpp"
#include "operation_stats.hpp"
#include "iupac_motif.hpp"


// nearly stateless class to read a IUPACMotifVectorReader from a stream
class IUPACMotifVectorReader {
public:
	struct Stats : OperationStats {
		Stats() { clear(); }
		
		virtual void clear() {
			num_motifs_loaded = 0;
			num_valid_motifs = 0;
		}
		
		virtual ostream& print( ostream& os ) const {
			os << num_motifs_loaded << " motifs loaded, and " << num_valid_motifs << " valid motifs retained." << endl;
			return os;
		}
		
		unsigned int	num_motifs_loaded,
						num_valid_motifs;
	};
		
	IUPACMotifVectorReader( BufferedReader& ist, bool use_bidirectional = false )
		: is( ist ), useBidirectional( use_bidirectional ) { }
	
	void	load( IUPACMotifVector& motifs, Stats& stats );
	
private:
	BufferedReader& is;
	bool useBidirectional;
};


#endif // IUPAC_MOTIF_VECTOR_READER_H
