/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  kmer_incidence_collector.cpp
 *
 *  Class for collecting the incidence of all k-mers in a set of
 *  promoters into a MotifIncidenceMap.
 */


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "kmer_encoder.hpp"
#include "motif_incidence_map.hpp"
#include "kmer_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "kmer_incidence_collector.hpp"


MotifIncidenceMap*
KmerIncidenceCollector::collectIncidence( const SequenceVector& seqs )
{
	KmerIncidenceMap* m = new KmerIncidenceMap( encoder );
	
	collectIncidence( seqs, *m );
	
	return m;
}


void
KmerIncidenceCollector::collectIncidence( const SequenceVector& seqs, KmerIncidenceMap& m )
{
	for( unsigned int i = 0; i < seqs.size(); ++i ) {
		const Sequence* sequence = seqs[ i ];
		
		KmerEncoder::KmerValue				value = KmerEncoder::INVALID_VALUE;
		Sequence::DataType::const_iterator  spos = encoder.getFirstPos( sequence->getData() );
		Sequence::DataType::const_iterator  epos = encoder.getLastPos( sequence->getData() );
		Sequence::DataType::size_type		pos = 0;
		unsigned int						chunkNumber = 0;
		
		while( spos <= epos ) {
			if( *spos == '#' )  ++chunkNumber;
			
			if( value == KmerEncoder::INVALID_VALUE )	value = encoder.computeKmerValue( spos );
			else										value = encoder.nextKmerValue( value, spos );
			
			if( value != KmerEncoder::INVALID_VALUE )	addInstance( m, value, MotifInstance( i, pos ) ); // NOTE: NOT distance from right -- distance from left
			++spos;
			++pos;
		}
	}
	
	// no need for this with positions
//	m.makeUniqueIncidence();
}

