/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  kolmogorov_smirnov_d.hpp
 *
 *  Class that performs a fast caching K-S test
 *  Inherits much of its rank-ordering functionality from MannWhitneyUCalculator
 */


#ifndef KOLMOGOROV_SMIRNOV_D_H
#define KOLMOGOROV_SMIRNOV_D_H


#include <iostream>
#include <iomanip>
#include <algorithm>
#include <numeric>
#include <vector>
#include <cmath>


#include "common.hpp"
#include "promoter.hpp"
#include "expression_statistics.hpp"
#include "univariate_expression_statistic_calculator.hpp"
#include "mark_set.hpp"
#include "mann_whitney_u.hpp"



const double	EPS1 = 0.001, EPS2 = 1.0e-8;

// procedure to approximate the CDF of the K-S d statistic
double
probks( float alam );


// K-S d statistic class
class KolmogorovSmirnovD : public Statistic {
public:
    KolmogorovSmirnovD( double d_val, double alam, double freq_val );
    
    KolmogorovSmirnovD( double freq_val = 0 ) : Statistic( true ), freq( freq_val ) { }
    KolmogorovSmirnovD( const KolmogorovSmirnovD& s ) : Statistic( s ), freq( s.freq ) { }
    
    virtual ~KolmogorovSmirnovD() { }
    
    virtual void	print( ostream& os ) const;
    virtual void	printHeader( ostream& os ) const;
    
public: // (should be) constant public data members
    double			freq, value;
};


// class to implement a fast caching calculator for a the Kolmogorov-Smirnov d statistic
class KolmogorovSmirnovDCalculator : public MannWhitneyUCalculator {
public:
    KolmogorovSmirnovDCalculator( const PromoterVector& promoters, unsigned int dimension = 0 );
    KolmogorovSmirnovDCalculator( const KolmogorovSmirnovDCalculator& calc, bool copyRanks = false );
    virtual ~KolmogorovSmirnovDCalculator() { }
    
    void				buildSortedSamples( const MarkSet& marks );
    
    virtual void		compute( const MarkSet& marks, Statistic& statistic ); // fix this to take a KolmogorovSmirnovD&
    
    // ack! terrible!
    virtual double		computeValue( const MarkSet& marks );
        
    
    // accessors
    const dvector&		getData0()		const { return data0; }
    const dvector&		getData1()		const { return data1; }

private:
    dvector				data0, data1;
    unsigned int		n0, n1;
};


#endif // KOLMOGOROV_SMIRNOV_D_H
