/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  bijective_map_filter.hpp
 *
 *  A simple functor for inverting a map.
 */

#ifndef MAP_INVERTER_H
#define MAP_INVERTER_H

#include <map>

// stateless class to invert a map
template< typename SrcMapType, typename DstMapType >
struct MapInverter {
	void	invert( const SrcMapType& src, DstMapType& dst )
	{
		dst.clear();
		for( typename SrcMapType::const_iterator i = src.begin(); i != src.end(); ++i ) {
			dst.insert( typename DstMapType::value_type( i->second, i->first ) );
		}
	}
};

#endif // MAP_INVERTER_H
