/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_collector.hpp
 *
 *  Base class for classes that collect the incidence of a set of motifs
 *  in a set of sequences into a MotifIncidenceMap.
 */


#ifndef MOTIF_INCIDENCE_COLLECTOR_H
#define MOTIF_INCIDENCE_COLLECTOR_H


#include "common.hpp"
#include "sequence.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_map.hpp"


class MotifIncidenceCollector {
public:
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs ) = 0;
	
protected:
	
	virtual void addInstance( MotifIncidenceMap& m, MotifIncidenceMap::MotifNumber motifNum, MotifInstance i );
	
};


#endif // MOTIF_INCIDENCE_COLLECTOR_H
