/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_map.hpp
 *
 *  Base class for storing a map of from motifs to their incidence.
 */


#ifndef MOTIF_INCIDENCE_MAP_H
#define MOTIF_INCIDENCE_MAP_H


#include <string>
#include <vector>
#include <iostream>


#include "common.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_set.hpp"



#ifdef MOTIFADE_USE_HASH_MAP
	#ifdef MOTIFADE_HASH_MAP_NOT_IN_EXT
		#include <hash_map>
	#else
		#include <ext/hash_map>
	#endif
	#ifdef MOTIFADE_DUMB_GNU_HASH_MAP
		using namespace __gnu_cxx;
	#endif
#else
	#include <map>
#endif



class MotifIncidenceMap {
public:
	typedef unsigned int								MotifNumber;
	
#ifdef MOTIFADE_USE_HASH_MAP
	typedef hash_map< MotifNumber, MotifIncidenceSet >	IncidenceMapType;
#else
	typedef map< MotifNumber, MotifIncidenceSet >		IncidenceMapType;
#endif
	
	typedef IncidenceMapType::const_iterator			iterator;
	typedef iterator									const_iterator;
	

public:
	MotifIncidenceMap() {}
	virtual ~MotifIncidenceMap() {}
	
	void clear();

	virtual void addInstance( MotifNumber n, const MotifInstance& i );
		
	virtual const MotifIncidenceSet* getIncidence( MotifNumber m ) const;
	
	void makeUniqueIncidence();
	
	virtual void getMotifName( MotifNumber m, string& motifName ) const = 0;
	
	unsigned int size() const;
	
	const_iterator begin() const;
	const_iterator end() const;
	
	iterator begin();
	iterator end();
	
protected:
	virtual void touchMotif( MotifNumber n );
	
private:
	IncidenceMapType iMap;
};



ostream& operator<<( ostream& os, const MotifIncidenceMap& m );


#endif // MOTIF_INCIDENCE_MAP_H
